#include <avr/io.h>   
#include <stdint.h>
#include <avr/interrupt.h>
#include "UART0.h"
#include "BusProtectionInterface.h"

ISR(USART0_RX_vect)
{
	uint8_t Data = UDR0;
	BusProtectionNewData(Data);
}

void UART0_init()
{
	UBRR0L = (F_CPU / (BAUD * 16L) - 1);
	UCSR0B = ((1<<RXEN0) | (1<<TXEN0) | (1<<RXCIE0));
	sei();
}

void UART0_put_char(char data)
{
	while (!(UCSR0A & (1<<UDRE0)));
	UDR0=data;
}

void UART0_print(char *buffer)
{
	while(*buffer!=0)
	{
		UART0_put_char (*buffer);
		buffer++;
	}
}

void UART0_put_hex(unsigned char data)
{
	UART0_put_char('0');
	UART0_put_char('x');
	if (((data>>4)+55)>='A') UART0_put_char((data>>4)+55); 
	else UART0_put_char(((data&0xF0)>>4)+48);
	
	if  ((data&0x0F)>9 )UART0_put_char((data&0x0F)+55); 
	else UART0_put_char((data&0x0F)+48);
}

void UART0_put_dec(unsigned int data)
{
	if(data==0)
	{
		UART0_put_char('0');
	}
	else
	{
		unsigned char i=0;
		unsigned char daten[5];
		while(data>0)
		{
			daten[i]=data%10+48;
			data=data/10;
			i++;
		}
		for(unsigned char j=i;j>0;j--)
		UART0_put_char(daten[j-1]);
	}
}